//
//  AHKABMainWindowController_IO.m
//  AH-K3001V Utilities
//
//  Created by FUJIDANA on Sat Feb 18 2006.
//  Copyright (c) 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKABMainWindowController.h"
#import "AHKABPeoplePickerWindowController.h"
#import "AHKPasswordWindowController.h"
#import "AHKProgressWindowController.h"
#import "AHKPerson.h"
#import "AHKPhone.h"
#import "AHKPhone_Address.h"
#import <AddressBook/AddressBook.h>

@interface AHKABMainWindowController (IO_Private)

//- (void)exportVCardsOpenPanelDidEnd:(NSOpenPanel *)openPanel returnCode:(int)returnCode contextInfo:(void *)contextInfo;
//- (void)importVCardsOpenPanelDidEnd:(NSOpenPanel *)openPanel returnCode:(int)returnCode contextInfo:(void *)contextInfo;
//- (void)importFromAddressBookSheetDidEnd:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo;
- (void)receivePeopleAlertDidEnd:(NSAlert *)alert returnCode:(int)returnCode contextInfo:(void *)contextInfo;
//- (void)sendPeopleAlertDidEnd:(NSAlert *)alert returnCode:(int)returnCode contextInfo:(void *)contextInfo;
- (BOOL)readDatabaseFromFile:(NSString *)path;
- (BOOL)writeDatabaseToFile:(NSString *)path withFormerFileStored:(BOOL)storedFlag extensionHidden:(BOOL)hiddenFlag;
- (NSString *)pathForDataFile;
- (void)updateReceivedDateWithDate:(NSDate *)date;
- (void)showAlertWithError:(NSError *)error;

@end


@implementation AHKABMainWindowController (IO)

#pragma mark methods to import and export with vCard

- (IBAction)exportVCards:(id)sender
{
	NSOpenPanel *openPanel = [NSOpenPanel openPanel];
	[openPanel setAllowsMultipleSelection:NO];
	[openPanel setCanChooseDirectories:YES];
	[openPanel setCanChooseFiles:NO];
	[openPanel setCanCreateDirectories:YES];
//	[openPanel setAccessoryView:fileFormatView];
	[openPanel setTitle:NSLocalizedStringFromTable(@"Export", @"AHKABLocalizable", @"exportVCardSheet.button.export")];
	[openPanel setPrompt:NSLocalizedStringFromTable(@"Export", @"AHKABLocalizable", @"exportVCardSheet.button.export")];
	
	[openPanel beginSheetForDirectory:nil
								 file:nil
								types:nil
					   modalForWindow:[self window]
						modalDelegate:self
					   didEndSelector:@selector(exportVCardsOpenPanelDidEnd:returnCode:contextInfo:)
						  contextInfo:nil];
}

- (void)exportVCardsOpenPanelDidEnd:(NSOpenPanel *)openPanel returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	if (returnCode == NSOKButton) {
        NSString		*directoryName	= [openPanel filename];
//		int				format			= [[NSUserDefaults standardUserDefaults] integerForKey:AHKABDefaultsVCardFormatIndexKey];
		int				format			= AHKKyoponVCardFormat;
		
		NSArray			*selectedCards	= [peopleController selectedObjects];
		NSEnumerator	*enumerator		= [selectedCards objectEnumerator];
		AHKPerson		*person;
		
		while (person = [enumerator nextObject]) {
			NSString	*name		= [NSString stringWithFormat:@"%03d_%@.vcf", [person number], [person name]];
			NSString	*filename	= [directoryName stringByAppendingPathComponent:name];
			[[person vCardRepresentationWithFormat:format] writeToFile:filename atomically:YES];
		}
	}
}

- (IBAction)importVCards:(id)sender
{
	NSOpenPanel *openPanel = [NSOpenPanel openPanel];
	[openPanel setCanChooseDirectories:NO];
	[openPanel setCanChooseFiles:YES];
	[openPanel setAllowsMultipleSelection:YES];
//	[openPanel setAccessoryView:fileFormatView];
	[openPanel setTitle:NSLocalizedStringFromTable(@"Import", @"AHKABLocalizable", @"importVCard.button.import")];
	[openPanel setPrompt:NSLocalizedStringFromTable(@"Import", @"AHKABLocalizable", @"importVCard.button.import")];
	
	[openPanel beginSheetForDirectory:nil
								 file:nil
								types:[self acceptableFileExtensions]
					   modalForWindow:[self window]
						modalDelegate:self
					   didEndSelector:@selector(importVCardsOpenPanelDidEnd:returnCode:contextInfo:)
						  contextInfo:nil];
}

- (void)importVCardsOpenPanelDidEnd:(NSOpenPanel *)openPanel returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	if (returnCode == NSOKButton) {
        NSArray			*filenames	= [openPanel filenames];
		NSEnumerator	*enumerator	= [filenames objectEnumerator];
//		int				format		= [[NSUserDefaults standardUserDefaults] integerForKey:AHKABDefaultsVCardFormatIndexKey];
		int				format			= AHKKyoponVCardFormat;
		NSString		*filePath;
		
		while (filePath = [enumerator nextObject]) {
			NSData		*vCardData	= [NSData dataWithContentsOfFile:filePath];
			AHKPerson	*person		= [[AHKPerson alloc] initWithVCardRepresentation:vCardData format:format];
			if (person != nil && [peopleController canAdd]) {
				[peopleController addObject:person];
			} else {
				// -- not yet iplemented --
			}
			[person release];
		}
	}
}


#pragma mark methods to import and export with Address Book

// methods for "Export to Address Book"

- (IBAction)exportToAddressBook:(id)sender
{
	NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	[alert setMessageText:NSLocalizedStringFromTable(@"Do you export currently selected cards to Address Book?", @"AHKABLocalizable", @"exportToAddressBookComfirm.message")];
	[alert setInformativeText:NSLocalizedStringFromTable(@"The imformation this application holds does not match completely with wthat Address Book holds. When you import cards from Address Book and then export them back to Address Book, some information will be lost.", @"AHKABLocalizable", @"exportToAddressBookComfirm.information")];
	[alert setAlertStyle:NSWarningAlertStyle];
	[alert addButtonWithTitle:NSLocalizedStringFromTable(@"OK", @"AHKABLocalizable", @"alertSheet.button.ok")];
	[alert addButtonWithTitle:NSLocalizedStringFromTable(@"Cancel", @"AHKABLocalizable", @"alertSheet.button.cancel")];
	[alert setHelpAnchor:@"ahkabhlp34"];
	[alert setShowsHelp:YES];
	
	[alert beginSheetModalForWindow:[self window]
					  modalDelegate:self
					 didEndSelector:@selector(exportToAddressBookAlertDidEnd:returnCode:contextInfo:)
						contextInfo:nil];
}

- (void)exportToAddressBookAlertDidEnd:(NSAlert *)alert returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	if (returnCode == NSAlertFirstButtonReturn) {
		NSUserDefaults	*userDefaults	= [NSUserDefaults standardUserDefaults];
		ABAddressBook	*addressBook	= [ABAddressBook sharedAddressBook];
		ABGroup			*group;
		
		NSString		*groupUid		= [userDefaults stringForKey:AHKABDefaultsExportABGroupUIDKey];
		
		if (groupUid != nil && 
		    [[addressBook recordClassFromUniqueId:groupUid] isEqualToString:@"ABGroup"] &&
			(group = (ABGroup *)[addressBook recordForUniqueId:groupUid])) {
			//
		} else {
			group = [[[ABGroup alloc] init] autorelease];
			[group setValue:NSLocalizedStringFromTable(@"Import from Kyopon", @"AHKABLocalizable", @"exportToAddressBook.groupName")
				forProperty:kABGroupNameProperty];
			[userDefaults setObject:[group uniqueId]
							 forKey:AHKABDefaultsExportABGroupUIDKey];
			[addressBook addRecord:group];
			
		}
		
		NSArray			*selectedCards	= [peopleController selectedObjects];
		NSEnumerator	*enumerator		= [selectedCards objectEnumerator];
		AHKPerson		*person;
		while (person = [enumerator nextObject]) {
			NSData		*data		= [person vCardRepresentationWithFormat:AHKAddressBookVCardFormat];
			ABPerson	*abPerson	= [[[ABPerson alloc] initWithVCardRepresentation:data] autorelease];
			if (abPerson) {
				[addressBook addRecord:abPerson];
				[group addMember:abPerson];
			}
		}
		[addressBook save];
	}
}

// methods for "Import from Address Book"
- (IBAction)importFromAddressBook:(id)sender
{
	AHKABPeoplePickerWindowController	*peoplePickerWindowController	= [AHKABPeoplePickerWindowController sharedWindowController];
	
	// display sheet
	[NSApp beginSheet:[peoplePickerWindowController window]
	   modalForWindow:[self window]
		modalDelegate:self
	   didEndSelector:@selector(importFromAddressBookSheetDidEnd:returnCode:contextInfo:)
		  contextInfo:nil];
}

- (void)importFromAddressBookSheetDidEnd:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	//[sheet orderOut:self];
	
	if(returnCode == NSOKButton) {
		AHKABPeoplePickerWindowController	*peoplePickerWindowController	= [AHKABPeoplePickerWindowController sharedWindowController];
		
		NSArray			*selectedPeople	= [peoplePickerWindowController selectedPeople];
		NSEnumerator	*enumerator		= [selectedPeople objectEnumerator];
		id				abPerson;
		
		while (abPerson = [enumerator nextObject]) {
			AHKPerson *person = [[AHKPerson alloc] initWithABPerson:abPerson];
			if (person != nil && [peopleController canAdd]) {
				[peopleController addObject:person];
			} else {
				// -- not iplemented --
			}
			[person release];
		}
	}
}


#pragma mark for save and revert

- (IBAction)backupDatabase:(id)sender
{
	NSString		*filenameMesssage	= NSLocalizedStringFromTable(@"Kyopon Backup - %@", @"AHKABLocalizable", @"backupDatabase.filenameMessage");
	NSUserDefaults	*userDefaults		= [NSUserDefaults standardUserDefaults];
	NSString		*shortDateFormat	= [userDefaults stringForKey:NSShortDateFormatString];
	
	NSString		*filenameDate		= [[NSCalendarDate calendarDate] descriptionWithCalendarFormat:shortDateFormat];
	
	NSSavePanel		*savePanel			= [NSSavePanel savePanel];
	
	[savePanel setRequiredFileType:@"ahkabbu"];
	//[savePanel setExtensionHidden:YES];
	[savePanel setCanSelectHiddenExtension:YES];
	[savePanel beginSheetForDirectory:nil
								 file:[NSString stringWithFormat:filenameMesssage, filenameDate]
					   modalForWindow:[self window]
						modalDelegate:self
					   didEndSelector:@selector(backupDatabaseSavePanelDidEnd:returnCode:contextInfo:)
						  contextInfo:nil];
}

- (void)backupDatabaseSavePanelDidEnd:(NSSavePanel *)savePanel returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	if (returnCode == NSOKButton) {
		[self writeDatabaseToFile:[savePanel filename]
			 withFormerFileStored:NO
				 extensionHidden:[savePanel isExtensionHidden]];
	}
}

- (IBAction)revertFromDatabaseBackup:(id)sender
{
	NSOpenPanel *openPanel = [NSOpenPanel openPanel];
	[openPanel setAllowsMultipleSelection:NO];
	[openPanel setCanChooseDirectories:NO];
	[openPanel setCanChooseFiles:YES];
	
	[openPanel beginSheetForDirectory:nil
								 file:nil
								types:[NSArray arrayWithObjects:@"ahkabbu", @"ahkabbuckup", nil]
					   modalForWindow:[self window]
						modalDelegate:self
					   didEndSelector:@selector(revertFromDatabaseBackupOpenPanelDidEnd:returnCode:contextInfo:)
						  contextInfo:nil];
}

- (void)revertFromDatabaseBackupOpenPanelDidEnd:(NSOpenPanel *)openPanel returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	if (returnCode == NSOKButton) {
//		[self readDatabaseFromFile:[openPanel filename]];
		[openPanel orderOut:nil];
		[self confirmRevertDatabaseFromFile:[openPanel filename]];
	}
}

#pragma mark for communication with Kyopon

- (IBAction)receivePeople:(id)sender
{
	[[self window] makeFirstResponder:nil];
	
	if ([[self people] count] > 0) {
		NSAlert *alert = [[[NSAlert alloc] init] autorelease];
		[alert addButtonWithTitle:NSLocalizedStringFromTable(@"Receive", @"AHKABLocalizable", @"alertSheet.button.receive")];
		[alert addButtonWithTitle:NSLocalizedStringFromTable(@"Cancel", @"AHKABLocalizable", @"alertSheet.button.cancel")];
		[alert setMessageText:NSLocalizedStringFromTable(@"Are you sure you want to overwrite the address book on this computer with the data received from your Kyopon?", @"AHKABLocalizable", @"receivePeopleSheet.message")];
		[alert setInformativeText:NSLocalizedStringFromTable(@"Any changes you've made on this computer will be lost.", @"AHKABLocalizable", @"receivePeopleSheet.information")];
		[alert setAlertStyle:NSInformationalAlertStyle];
	
		[alert setHelpAnchor:@"ahkabhlp22"];
		[alert setShowsHelp:YES];
		
		[alert beginSheetModalForWindow:[self window]
						  modalDelegate:self
						 didEndSelector:@selector(receivePeopleAlertDidEnd:returnCode:contextInfo:)
							contextInfo:nil];
	} else {
		[self receivePeopleAlertDidEnd:nil returnCode:NSAlertFirstButtonReturn contextInfo:nil];
	}
}

- (void)receivePeopleAlertDidEnd:(NSAlert *)alert returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	[[alert window] orderOut:self];
	if (returnCode == NSAlertFirstButtonReturn) {
		AHKPhone					*phone						= [[[AHKPhone alloc] init] autorelease];
		AHKPasswordWindowController	*passwordWindowController	= [AHKPasswordWindowController sharedWindowController];
		AHKProgressWindowController	*progressWindowController	= [AHKProgressWindowController sharedWindowControllerWithParentWindow:[self window]];
		NSString					*password					= [passwordWindowController findPassword];
		NSArray						*people;
		
		if (password == nil) {
			[passwordWindowController inputPasswordForWindow:[self window]
											   modalDelegate:self
										didEndActionSelector:@selector(receivePeople:)];
			return;
		}
		
		NSError *error;
		BOOL flag = [phone readPeople:&people password:password progress:progressWindowController error:&error];
		if (flag == NO) { // failed to receive people
			// Since Mac OS X 10.3 does not support error-presentation and error-recovery architectures, handle the error manually.
			if ([[error domain] isEqualToString:AHKErrorDomain] &&
				([error code] == AHKPhoneIncorrectPasswordError ||
				 [error code] == AHKPhoneInapplicablePasswordStringEncodingError || 
				 [error code] == AHKPhoneInapplicablePasswordStringLengthError)) { // in case password is incorrect
				[passwordWindowController inputPasswordForWindow:[self window]
												   modalDelegate:self
											didEndActionSelector:@selector(receivePeople:)];
			} else { // in case another error occurred, simply show an alert dialog.
				[self showAlertWithError:error];
			}
		} else { // succeed in receiving people
			NSUndoManager	*undoManager	= [[self window] undoManager];
			[self setPeople:people];
			[self updateReceivedDateWithDate:[NSDate date]];
			[undoManager setActionName:NSLocalizedStringFromTable(@"Apply Received Data", @"AHKABLocalizable", @"undo.receive")];
		}
	}
}

//			if (password == nil || [phone readPeople:&people withPassword:password progress:progressWindowController] == NO) {
//				[passwordWindowController inputPasswordForWindow:[self window]
//												   modalDelegate:self 
//											didEndActionSelector:@selector(receivePeople:)];
//			} else {
//				NSUndoManager	*undoManager	= [[self window] undoManager];
//				[self setPeople:people];
//				[self updateReceivedDateWithDate:[NSDate date]];
//				[undoManager setActionName:NSLocalizedStringFromTable(@"Apply Received Data", @"AHKABLocalizable", @"undo.receive")];
//			}
//		}
//		@catch(NSException *exception) {
//			NSString *message = NSLocalizedStringFromTable(@"Couldn't receive the address book.", @"AHKABLocalizable", nil);
//			[self showAlertWithMessage:message exception:exception];
//		}


// --- send address book to IR-EDGE PHONE.
- (IBAction)sendPeople:(id)sender
{
	[[self window] makeFirstResponder:nil];
	
	NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	[alert addButtonWithTitle:NSLocalizedStringFromTable(@"Send", @"AHKABLocalizable", @"alertSheet.button.send")];
	[alert addButtonWithTitle:NSLocalizedStringFromTable(@"Cancel", @"AHKABLocalizable", @"alertSheet.button.cancel")];
	[alert setMessageText:NSLocalizedStringFromTable(@"Are you sure you want to overwrite the address book on your Kyopon with the data send from this computer?", @"AHKABLocalizable", @"sendPeopleSheet.message")];
	[alert setInformativeText:NSLocalizedStringFromTable(@"Any changes you've made on your Kyopon will be lost.", @"AHKABLocalizable", @"sendPeopleSheet.information")];
	[alert setAlertStyle:NSInformationalAlertStyle];
	[alert setHelpAnchor:@"ahkabhlp21"];
	[alert setShowsHelp:YES];
	
	[alert beginSheetModalForWindow:[self window]
					  modalDelegate:self
					 didEndSelector:@selector(sendPeopleAlertDidEnd:returnCode:contextInfo:)
						contextInfo:nil];
}

- (void)sendPeopleAlertDidEnd:(NSAlert *)alert returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	[[alert window] orderOut:self];
	
	if (returnCode == NSAlertFirstButtonReturn) {
		AHKPhone					*phone						= [[[AHKPhone alloc] init] autorelease];
		AHKPasswordWindowController *passwordWindowController	= [AHKPasswordWindowController sharedWindowController];
		AHKProgressWindowController *progressWindowController	= [AHKProgressWindowController sharedWindowControllerWithParentWindow:[self window]];
		NSString					*password					= [passwordWindowController findPassword];
		
		if (password == nil) {
			[passwordWindowController inputPasswordForWindow:[self window]
											   modalDelegate:self 
										didEndActionSelector:@selector(sendPeople:)];
			return;
		} 
		
		NSError *error;
		BOOL flag = [phone writePeople:[self people] withPassword:password progress:progressWindowController error:&error];
		if (flag == NO) { // failed to send people
			// Since Mac OS X 10.3 does not support error-presentation and error-recovery architectures, handle the error manually.
			if ([[error domain] isEqualToString:AHKErrorDomain] &&
				([error code] == AHKPhoneIncorrectPasswordError ||
				 [error code] == AHKPhoneInapplicablePasswordStringEncodingError || 
				 [error code] == AHKPhoneInapplicablePasswordStringLengthError)) { // in case password is incorrect
				[passwordWindowController inputPasswordForWindow:[self window]
												   modalDelegate:self
											didEndActionSelector:@selector(sendPeople:)];
			} else { // in case another error occurred, simply show an alert dialog.
				[self showAlertWithError:error];
			}
		} else { // succeed in sending people
			[[NSUserDefaults standardUserDefaults] setObject:[NSDate date] forKey:AHKABDefaultsLastSentDateKey];
		}
	}
}


#pragma mark other public methods
- (void)confirmRevertDatabaseFromFile:(NSString *)filename
{
	NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	[alert setMessageText:NSLocalizedStringFromTable(@"Reverting will cause your current database to be overwirtten", @"AHKABLocalizable", @"revertComfirm.message")];
	[alert setInformativeText:[NSString stringWithFormat:NSLocalizedStringFromTable(@"The backup database %@ will be copied over your existing database.", @"AHKABLocalizable", @"revertComfirm.information"), [filename lastPathComponent]]];
	[alert setAlertStyle:NSCriticalAlertStyle];
	[alert addButtonWithTitle:NSLocalizedStringFromTable(@"OK", @"AHKABLocalizable", @"alertSheet.button.ok")];
	[alert addButtonWithTitle:NSLocalizedStringFromTable(@"Cancel", @"AHKABLocalizable", @"alertSheet.button.cancel")];
	
	int result = [alert runModal];
	
	if (result == NSAlertFirstButtonReturn) {
		[self readDatabaseFromFile:filename];
	}
}

- (BOOL)loadDefaultDatabase
{
	return [self readDatabaseFromFile:[self pathForDataFile]];
}

- (BOOL)storeDefaultDatabase
{
	return [self writeDatabaseToFile:[self pathForDataFile] 
									 withFormerFileStored:YES
										  extensionHidden:NO];
}
										  
- (NSArray *)acceptableFileExtensions
{
	return [NSArray arrayWithObjects: @"vcf", @"vcard", @"txt", nil];
	 //NSFileTypeForHFSTypeCode('TEXT')
}

#pragma mark private auxiliary methods

- (BOOL)readDatabaseFromFile:(NSString *)path
{
	NSFileManager	*fileManager	= [NSFileManager defaultManager];
	BOOL			isDirectory;
	if ([fileManager fileExistsAtPath:path isDirectory:&isDirectory] && isDirectory == NO) {
		id dataContent = [NSKeyedUnarchiver unarchiveObjectWithFile:path];
		if (dataContent != nil) {
			[self setPeople:dataContent];
			return YES;
		}
	}
	return NO;
}

- (BOOL)writeDatabaseToFile:(NSString *)path withFormerFileStored:(BOOL)storedFlag extensionHidden:(BOOL)hiddenFlag
{
	NSFileManager	*fileManager	= [NSFileManager defaultManager];
	
	if (storedFlag == YES) {
		// if a data file already exists, rename it by adding tilde at the end of its filename.
		NSString		*pathExtension	= [path pathExtension];
		NSString		*backupFilename	= [[[path stringByDeletingPathExtension] stringByAppendingString:@"~"]
		stringByAppendingPathExtension:pathExtension];
		
		if ([fileManager fileExistsAtPath:path]) {
			if ([fileManager fileExistsAtPath:backupFilename]) {
				[fileManager removeFileAtPath:backupFilename handler:nil];
			}
			[fileManager movePath:path toPath:backupFilename handler:nil];
		}
	}
	
	// store data
	if ([self people] != nil) {
		if ([NSKeyedArchiver archiveRootObject:[self people] toFile:path]) {
			// If the data are stored successfully, then set the path extension hidden or not.
			NSDictionary *attributes = [NSDictionary dictionaryWithObject:[NSNumber numberWithBool:hiddenFlag]
																   forKey:NSFileExtensionHidden];
			
			[fileManager changeFileAttributes:attributes
									   atPath:path];
			return YES;
		}
	}

	return NO;
	
}

- (NSString *)pathForDataFile
{
	NSFileManager *fileManager = [NSFileManager defaultManager];
	
//	// NSApplicationSupportDirectory is available in Mac OS X 10.4 and later.
//	NSArray *array = NSSearchPathForDirectoriesInDomains(NSApplicationSupportDirectory, NSUserDomainMask, YES);
	
	// if "Application Support" doesn't exist, create it.
	NSString *pathForApplicationSupport = [[NSHomeDirectory( )
		stringByAppendingPathComponent: @"Library"]
		stringByAppendingPathComponent:@"Application Support"];
	if ([fileManager fileExistsAtPath:pathForApplicationSupport] == NO) {
		[fileManager createDirectoryAtPath:pathForApplicationSupport attributes:nil];
	}
	
	// if "AH-K3001V Utilities" doesn't exist, create it.
	NSString *pathForDataDirectory = [pathForApplicationSupport stringByAppendingPathComponent:@"AH-K3001V Utilities"];
	if ([fileManager fileExistsAtPath:pathForDataDirectory] == NO) {
		[fileManager createDirectoryAtPath:pathForDataDirectory attributes:nil];
	}
	
	// return path for the data file
	return [pathForDataDirectory stringByAppendingPathComponent:@"AddressBookData.ahkutil"];
}

// small method to support undoing and redoing of the last sync date
- (void)updateReceivedDateWithDate:(NSDate *)date
{
	NSUndoManager	*undoManager	= [[self window] undoManager];
	NSUserDefaults	*userDefaults	= [NSUserDefaults standardUserDefaults];
	[undoManager registerUndoWithTarget:self selector:@selector(updateReceivedDateWithDate:) object:[userDefaults objectForKey:AHKABDefaultsLastReceivedDateKey]];
	[userDefaults setObject:date forKey:AHKABDefaultsLastReceivedDateKey];
}

//
//- (void)updateWithPeople:(NSMutableArray *)array date:(NSDate *)date
//{
//	NSUndoManager	*undoManager	= [[self window] undoManager];
//	NSUserDefaults	*userDefaults	= [NSUserDefaults standardUserDefaults];
//	[[undoManager prepareWithInvocationTarget:self] updateWithPeople:[self people] date:[userDefaults objectForKey:AHKABDefaultsLastReceivedDateKey]];
//	
//	// To avoid an undo invocation of -setPeople: being called twice, temporally disable undo manager (-setPeople: also prepares invocation for undo). If not, undo performance goes down.
//	[undoManager disableUndoRegistration];
//	[self setPeople:array];
//	[undoManager enableUndoRegistration];
//	
//	[userDefaults setObject:date forKey:AHKABDefaultsLastReceivedDateKey];
//	
//	[undoManager setActionName:NSLocalizedStringFromTable(@"Apply Received Data", @"AHKABLocalizable", @"undo.receive")];
//}


// --- -showAlertWithMessage:exception: was replaced with this method.
// --- Mac OS X 10.3 does not support +alertWithError: of NSError, generate alert manually.

- (void)showAlertWithError:(NSError *)error
{
	NSAlert *alert = [[[NSAlert alloc] init] autorelease];
	
	NSString *description = [error localizedDescription];
	if (description) {
		[alert setMessageText:description];
	}
//	[alert setInformativeText:<#(NSString *)informativeText#>];
	[alert addButtonWithTitle:NSLocalizedStringFromTable(@"OK", @"AHKABLocalizable", @"alertSheet.button.ok")];
	[alert setAlertStyle:NSCriticalAlertStyle];
	[alert setHelpAnchor:@"ahkabhlp1021"];
	[alert setShowsHelp:YES];
	
	[alert beginSheetModalForWindow:[self window]
					  modalDelegate:self
					 didEndSelector:nil
		                contextInfo:nil];
}

@end
